var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import fs from 'node:fs/promises';
import path from 'node:path';
import { logger } from '../../shared/logger.js';
// Write output to file. path is relative to the cwd
export const writeOutputToDisk = (output, config) => __awaiter(void 0, void 0, void 0, function* () {
    const outputPath = path.resolve(config.cwd, config.output.filePath);
    logger.trace(`Writing output to: ${outputPath}`);
    yield fs.writeFile(outputPath, output);
});
//# sourceMappingURL=writeOutputToDisk.js.map